package gov.cms.grouper.snf.component.v100;

import gov.cms.grouper.snf.model.enums.NursingCmg;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnfComponentTest {

  @Test
  public void testGetHIPPSCode() {
    Assertions.assertEquals("AAAA0",
        SnfComponent.getHIPPSCode("TA", "SA", NursingCmg.ES3, "NA", 0));
    Assertions.assertEquals("FCMA1",
        SnfComponent.getHIPPSCode("TF", "SC", NursingCmg.CDE1, "NA", 1));
    Assertions.assertEquals("FCMA",
        SnfComponent.getHIPPSCode("TF", "SC", NursingCmg.CDE1, "NA", null));
  }

  @Test
  public void testHasIPA() {
    Assertions.assertEquals(true, SnfComponent.hasIPA(0, 1, 100));
    Assertions.assertEquals(false, SnfComponent.hasIPA(1, 1, 100));
    Assertions.assertEquals(false, SnfComponent.hasIPA(1, 1, 105));
    Assertions.assertEquals(false, SnfComponent.hasIPA(1, 99, 100));



  }

  @Test
  public void testExec() {

  }


}
